% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{normalize_paths}
\alias{normalize_paths}
\title{Normalize the pathway matrix by rows}
\usage{
normalize_paths(path_vals, metaginfo)
}
\arguments{
\item{path_vals}{SummarizedExperiment or matrix of the pathway values}

\item{metaginfo}{Pathways object}
}
\value{
SummarizedExperiment or matrix of normalized pathway values,
depending on the class of \code{path_vals}.
}
\description{
Due to the nature of the Hipathia method, the length of a pathway may
influence its signal rank. In order to compare signal values among
subpathways, we strongly recommend to normalize the matrix with this
normalization.
}
\details{
This function removes the bias caused by the length of the subpathways
by dividing by the value obtained from running the method with a basal
value of 0.5 at each node.
}
\examples{
data(path_vals)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
path_normalized <- normalize_paths(path_vals, pathways)

}
