% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{node_color}
\alias{node_color}
\title{Get colors of the nodes from a comparison file}
\usage{
node_color(
  comp,
  metaginfo,
  group_by = "pathway",
  colors = "classic",
  conf = 0.05,
  adjust = TRUE
)
}
\arguments{
\item{comp}{Comparison file as returned by \code{do_wilcoxon}. Must include a
column named "UP/DOWN" with the sign of the comparison coded as 
\code{UP} or \code{DOWN}, a column named "p.value" of raw p.values and 
a column named "FDRp.value" of adjusted p.values.}

\item{metaginfo}{Object of pathways.}

\item{group_by}{How to group the subpathways to be visualized. By default
they are grouped by the pathway to which they belong. Available groupings
include "uniprot", to group subpathways by their annotated Uniprot functions,
"GO", to group subpathways by their annotated GO terms, and "genes", to group
subpathways by the genes they include. Default is set to "pathway".}

\item{colors}{Either a character vector with 3 colors (indicating,
in this order, down-regulation, non-significance and up-regulation colors)
 or a key name indicating the color scheme to be used. Options are:}

\item{conf}{Level of significance of the comparison for the adjusted p-value.}

\item{adjust}{Boolean, whether to adjust the p.value from the comparison. 
Default is TRUE.}
}
\value{
List of color vectors, named by the pathways to which they belong.
The color vectors represent the differential expression
of the nodes in each pathway.
}
\description{
Computes the colors of the nodes depending on the sign and p.value from the 
provided file. Significant up- and down-regulated nodes
are depicted with the selected color, with a gradient towards the
non-significant color depending on the value of the p-value.
Smaller p-values give rise to purer colors than higher p-values.
}
\section{Slots}{

\describe{
\item{\code{classic}}{ColorBrewer blue, white and colorBrewer red.}

\item{\code{hipathia}}{Hipathia predefined color scheme: 
Green, white and orange.
By default \code{classic} color scheme is applied.}
}}

\examples{
data(results)
data(brca)
pathways_list <- c("hsa03320", "hsa04012")
pathways <- load_pathways(species = "hsa", pathways_list)
comp <- do_wilcoxon(results[["nodes"]], "group", "Tumor", "Normal")
colors_de <- node_color(comp, pathways)

}
