% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_sif.R
\name{mgi_from_sif}
\alias{mgi_from_sif}
\title{Create a Pathways object from SIF files}
\usage{
mgi_from_sif(sif.folder, spe, entrez_symbol = NULL, dbannot = NULL)
}
\arguments{
\item{sif.folder}{Path to the folder in which SIF and ATT files are stored.}

\item{spe}{Species}

\item{entrez_symbol}{Relation between Entrez (NCBI) genes and gene symbols.
Data.frame with 2 columns: First column is the EntrezGene ID, second column
is the gene Symbol. The genes in the nodes of the pathways should be defined
by Entrez IDs in the SIF and ATT files of the pathways. In order to be more
readable, gene names are used when plotting the pathways.}

\item{dbannot}{Functional annotation of the genes in the pathways to create
function nodes.}
}
\value{
A pathways object with the same structure of that returned by
function \code{load_pathways}.
}
\description{
Creates a Pathways object from the information of a pathway stored in a SIF
file with some attributes. This pathways object can be used by function
\code{hipathia} to analyze data.
}
