% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{hipathia}
\alias{hipathia}
\title{Computes the level of activation of the subpathways for each
of the samples}
\usage{
hipathia(
  genes_vals,
  metaginfo,
  uni.terms = FALSE,
  GO.terms = FALSE,
  sel_assay = 1,
  decompose = FALSE,
  scale = TRUE,
  maxnum = 100,
  verbose = TRUE,
  tol = 1e-06,
  test = TRUE
)
}
\arguments{
\item{genes_vals}{A SummarizedExperiment or matrix with the normalized
expression values of the genes. Rows represent genes and columns represent
samples. Rownames() must be accepted gene IDs.}

\item{metaginfo}{Pathways object}

\item{uni.terms}{Boolean, whether to compute functional analysis with
Uniprot keywords.}

\item{GO.terms}{Boolean, whether to compute functional analysis with
Gene Ontology terms.}

\item{sel_assay}{Character or integer, indicating the assay to be processed
in the SummarizedExperiment. Only applied if \code{genes_vals} is a
\code{SummarizedExperiment}.Default is 1.}

\item{decompose}{Boolean, whether to compute the values for the decomposed
subpathways. By default, effector subpathways are computed.}

\item{scale}{Boolean, whether to scale the values matrix to [0,1]. Default is
TRUE.}

\item{maxnum}{Number of maximum iterations when iterating the signal
through the loops into the pathways}

\item{verbose}{Boolean, whether to show details about the results of
the execution of hipathia}

\item{tol}{Tolerance for the difference between two iterations when
iterating the signal through the loops into the pathways}

\item{test}{Boolean, whether to test the input objects. Default is TRUE.}
}
\value{
A MultiAssayExperiment object with the level of activation of the
subpathways from
the pathways in \code{pathigraphs} for the experiment
with expression values in \code{genes_vals}.
}
\description{
#@importFrom igraph
}
\examples{
data(exp_data)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
results <- hipathia(exp_data, pathways, verbose = TRUE)
\dontrun{results <- hipathia(exp_data, pathways, decompose = TRUE,
verbose = FALSE)}

}
