% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hhead}
\alias{hhead}
\title{Head function for SummarizedExperiment, data.frames and matrix objects}
\usage{
hhead(mat, n = 5, sel_assay = 1)
}
\arguments{
\item{mat}{Object to be shown}

\item{n}{Number of rows and columns}

\item{sel_assay}{Character or integer, indicating the assay to be translated
in the SummarizedExperiment. Default is 1.}
}
\value{
Matrix with as much as \code{n} rows and \code{n} columns.
}
\description{
Shows the first \code{n} rows and the first \code{n} columns of a matrix,
in case the matrix has more than \code{n+5} rows or columns.
Otherwise, it shows all the rows or columns, respectively.
}
\examples{
mat <- matrix(rnorm(100), ncol = 10)
hhead(mat)
hhead(mat, 3)
hhead(mat, 7)

}
