% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{heatmap_plot}
\alias{heatmap_plot}
\title{Plots subpathways heatmap}
\usage{
heatmap_plot(
  data,
  group = NULL,
  sel_assay = 1,
  colors = "classic",
  sample_clust = TRUE,
  variable_clust = FALSE,
  labRow = NULL,
  labCol = NULL,
  sample_colors = NULL,
  scale = TRUE,
  save_png = NULL,
  legend = TRUE,
  legend_xy = "topright",
  pch = 15,
  main = NULL
)
}
\arguments{
\item{data}{Either a SummarizedExperiment or a matrix with the values to be 
plotted. Rows are features and columns are samples.}

\item{group}{Either a character indicating the name of the column in 
colData 
including the classes to plot, or a character vector with the class to 
which each sample belongs. Samples must be ordered as in \code{data}. 
By default, all samples will be assigned to the same class.}

\item{sel_assay}{Character or integer, indicating the assay to be normalized 
in the SummarizedExperiment. Default is 1.}

\item{colors}{Either a character vector with colors or a key name
indicating the color scheme to be used in the heatmap.
If a character vector is provided, it is recommended to provide at
least 3 colors. Three different predefined color schemes may be
selected by providing a key name. Options are:
* \code{classic} Blue for lower values, white for medium values,
red for higher values.
* \code{hipathia} Hipathia predefined color scheme: Green for lower
values, white for medium values, orange for higher values.
* \code{redgreen} Green for lower values, black for medium values,
red for higher values.
By default \code{classic} color scheme is applied.}

\item{sample_clust}{Boolean, whether to cluster samples (columns).
By default TRUE.}

\item{variable_clust}{Boolean, whether to cluster variables (rows).
By default FALSE. If TRUE, rows with 0 variance are removed.}

\item{labRow, labCol}{Character vectors with row and column labels
to be used. By default rownames(data) or colnames(data)
are used, respectively.}

\item{sample_colors}{Named character vector of colors. The names of
the colors must be the classes in \code{group}. Each sample will
be assigned the color corresponding to its class, taken from the
\code{group} vector. By default a color will be assigned
automatically to each class.}

\item{scale}{Boolean, whether to scale each row to the interval [0,1].
Default is TRUE.}

\item{save_png}{Path to the file where the image as PNG will be saved.
By default, the image is not saved.}

\item{legend}{Boolean, whether to display a legend.}

\item{legend_xy}{Position for the legend, in case \code{legend} is TRUE.}

\item{pch}{Graphical parameter from \code{par()} function.}

\item{main}{Main title of the image}
}
\value{
Heatmap of the values of the subpathways
}
\description{
Plots a heatmap with the values of the subpathways.
}
\examples{
data(brca_design)
data(path_vals)
sample_group <- brca_design[colnames(path_vals),"group"]
heatmap_plot(path_vals, group = sample_group)
heatmap_plot(path_vals, group = "group", colors = "hipathia",
variable_clust = TRUE)

}
