% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{get_pathways_summary}
\alias{get_pathways_summary}
\title{Compute pathway summary}
\usage{
get_pathways_summary(comp, metaginfo, conf = 0.05)
}
\arguments{
\item{comp}{Comparison data frame as returned by the \code{do_wilcoxon}
function.}

\item{metaginfo}{Pathways object}

\item{conf}{Level of significance of the comparison for the adjusted
p-value. Default is 0.05.}
}
\value{
Table with the summarized information for each of the pathways.
Rows are the analized pathways. Columns are:
* \code{num_total_paths} Number of total subpathways in which each pathway
is decomposed.
* \code{num_significant_paths} Number of significant subpathways in the
provided comparison.
* \code{percent_significant_paths} Percentage of significant subpathways
from the total number of subpathways in a pathway.
* \code{num_up_paths} Number of significant up-regulated subpathways in the
provided comparison.
* \code{percent_up_paths} Percentage of significant up-regulated subpathways
from the total number of subpathways in a pathway.
* \code{num_down_paths} Number of significant down-regulated subpathways in
the provided comparison.
* \code{percent_down_paths} Percentage of significant down-regulated
subpathways from the total number of subpathways in a pathway.
}
\description{
Computes a summary of the results, summarizing the number and proportion
of up- and down-regulated subpathways in each pathway.
}
\examples{
data(comp)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
get_pathways_summary(comp, pathways)

}
