% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_pathways_annotations}
\alias{get_pathways_annotations}
\title{Get Pathways functional annotations}
\usage{
get_pathways_annotations(pathway_names, metaginfo, dbannot, collapse = FALSE)
}
\arguments{
\item{pathway_names}{Character vector of the names of the pathways}

\item{metaginfo}{Pathways object}

\item{dbannot}{Either a string indicating which precomputed annotation
to use ("uniprot" for Uniprot Keywords or "GO" for Gene Ontology terms),
or a dataframe with the annotation of the genes to the functions. First
column are gene symbols, second column the functions.}

\item{collapse}{Boolean, whether to collapse all functions of the same
path in a single character string.}
}
\value{
2-columns matrix with the annotations of each pathway ID in the
annotation \code{dbannot}.
}
\description{
Get functional annotation of the pathways, either for a particular
annotation or a stored one.
}
\examples{
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
pathway_names <- c("P-hsa03320-37", "P-hsa03320-61", "P-hsa03320-46",
"P-hsa03320-57", "P-hsa03320-64", "P-hsa03320-47", "P-hsa03320-65")
\dontrun{get_pathways_annotations(pathway_names, pathways, "GO")}
get_pathways_annotations(pathway_names, pathways, "uniprot")

}
