% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_pathway_functions}
\alias{get_pathway_functions}
\title{Returns functions related to a pathway}
\usage{
get_pathway_functions(
  pathigraph,
  dbannot,
  entrez2hgnc,
  use_last_nodes = TRUE,
  unique = TRUE
)
}
\arguments{
\item{pathigraph}{Pathway object}

\item{dbannot}{Dataframe with the annotation of the genes to the functions.
First column are gene symbols, second column the functions.}

\item{entrez2hgnc}{Relation between Entrez and HGNC genes.}

\item{use_last_nodes}{Boolean, whether to annotate functions to the last
nodes of the pathways or not. If FALSE, functions will refer to all the nodes
of the pathway.}

\item{unique}{Boolean, whether to return the first function for each path.}
}
\value{
List of annotations from pathways to functions
}
\description{
Returns functions related to a pathway
}
