% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_paths_data}
\alias{get_paths_data}
\title{Gets the object of subpathway activation values}
\usage{
get_paths_data(results, matrix = FALSE)
}
\arguments{
\item{results}{Results object as returned by \code{hipathia}.}

\item{matrix}{Boolean, if TRUE the function returns a matrix object, if
FALSE (as default) returns a SummarizedExperiment object.}
}
\value{
Object, either a SummarizedExperiment or a matrix, with the levels
of activation of each decomposed subpathway for each sample.
}
\description{
This function returns the object with the levels of activation of each
subpathway for each sample. Rows represent the subpathways and columns
represent the samples. Each cell is the value of activation of a subpathway
in a sample.

Rownames are the IDs of the subpathways. In order to transform IDs into
readable names, use \code{get_path_names}.

Effector subpathways are subgraphs of a pathway including all the paths
leading to an effector protein. Effector proteins are defined as final
nodes in the graph. Each effector protein (final node) in a pathway
defines its own effector subpathway as the nodes and edges in a path leading
to it.

Decomposed subpathways are subgraphs of a pathway including all the paths
starting in a receptor protein and ending in an effector protein. Receptor
proteins are defined as initial nodes and effector proteins are defined
as final nodes in the graph. Each effector subpathway can be decomposed
in as many decomposed subpathways as initial nodes it includes.
}
\examples{
data(results)
path_vals <- get_paths_data(results)

}
