% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_path_names}
\alias{get_path_names}
\title{Tranlates path IDs to path names}
\usage{
get_path_names(metaginfo, names, maxchar = NULL)
}
\arguments{
\item{metaginfo}{Pathways object}

\item{names}{Character vector with the subpathway IDs to be translated}

\item{maxchar}{Integer, describes the number of maximum characters to
be shown. By default no filter is applied.}
}
\value{
A character vector including the readable names of the
subpathways IDs, in the same order as provided.
}
\description{
Translates the subpathway IDs to readable and comprensible names.

For effector subpathways, the names of the subpathways are encoded
as "pathway: effector_protein", where "pathway" is the pathway to
which the subpathway belongs and "effector_protein" is the name of
the last node in the subpathway.

For decomposed subpathways, the names of the subpathways are encoded
as "pathway: receptor_protein - effector_protein", where "pathway" is
the pathway to which the subpathway belongs, "receptor_protein" is the
name of the initial node of the subpathway and "effector_protein" is
the name of the last node in the subpathway.
}
\examples{
data(path_vals)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
translated_names <- get_path_names(pathways, rownames(path_vals))

}
