% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_node_names}
\alias{get_node_names}
\title{Tranlates node IDs to node names}
\usage{
get_node_names(metaginfo, names, maxchar = NULL)
}
\arguments{
\item{metaginfo}{Pathways object}

\item{names}{Character vector with the subpathway IDs to be translated}

\item{maxchar}{Integer, describes the number of maximum characters to
be shown. By default no filter is applied.}
}
\value{
A character vector including the readable names of the
subpathways IDs, in the same order as provided.
}
\description{
Translates the node IDs to readable and comprensible names.

The names of the nodes are encoded
as "pathway: name", where "pathway" is the pathway to
which the node belongs and "node" is the name of
the node. Nodes may include more genes than the one depicted in the name.
}
\examples{
data(results)
pathways_list <- c("hsa03320", "hsa04012")
pathways <- load_pathways(species = "hsa", pathways_list)
node_vals <- get_nodes_data(results)
translated_names <- get_node_names(pathways, rownames(node_vals))

}
