% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_go_names}
\alias{get_go_names}
\title{Tranlates GO IDs to GO names}
\usage{
get_go_names(names, species, maxchar = NULL, disambiguate = FALSE)
}
\arguments{
\item{names}{Character vector with the GO IDs to be translated.}

\item{species}{Species of the samples.}

\item{maxchar}{Integer, describes the number of maximum characters to
be shown. By default no filter is applied.}

\item{disambiguate}{Boolean, whether to return unique strings by
disambiguating with numbers.}
}
\value{
A character vector including the readable names of the
GO IDs, in the same order as provided.
}
\description{
Translates the GO IDs to readable and comprensible names.
}
\examples{
data(go_vals)
get_go_names(rownames(go_vals), "hsa")

}
