% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{do_wilcoxon}
\alias{do_wilcoxon}
\title{Apply Wilcoxon test}
\usage{
do_wilcoxon(
  data,
  group,
  g1,
  g2,
  paired = FALSE,
  adjust = TRUE,
  sel_assay = 1,
  order = FALSE
)
}
\arguments{
\item{data}{Either a SummarizedExperiment object or a matrix, containing the
values. Columns represent samples.}

\item{group}{Either a character indicating the name of the column in colData
including the classes to compare, or a character vector with the class to
which each sample belongs.
Samples must be ordered as in \code{data}}

\item{g1}{String, label of the first group to be compared}

\item{g2}{String, label of the second group to be compared}

\item{paired}{Boolean, whether the samples to be compared are paired.
If TRUE, function \code{wilcoxsign_test} from package \code{coin} is
used. If FALSE, function \code{wilcox.test} from package \code{stats}
is used.}

\item{adjust}{Boolean, whether to adjust the p.value with
Benjamini-Hochberg FDR method}

\item{sel_assay}{Character or integer, indicating the assay to be normalized
in the SummarizedExperiment. Default is 1.}

\item{order}{Boolean, whether to order the results table by the
\code{FDRp.value} column. Default is FALSE.}
}
\value{
Dataframe with the result of the comparison
}
\description{
Performs a Wilcoxon test for the values in \code{sel_vals} comparing
conditions \code{g1} and \code{g2}
}
\examples{
data(path_vals)
data(brca_design)
sample_group <- brca_design[colnames(path_vals),"group"]
comp <- do_wilcoxon(path_vals, sample_group, g1 = "Tumor", g2 = "Normal")

}
