% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{do_pca}
\alias{do_pca}
\title{Performs a Principal Components Analysis}
\usage{
do_pca(data, sel_assay = 1, cor = FALSE)
}
\arguments{
\item{data}{SummarizedExperiment or matrix of values to be analyzed. Samples
must be represented in the columns.}

\item{sel_assay}{Character or integer, indicating the assay to be normalized
in the SummarizedExperiment. Default is 1.}

\item{cor}{A logical value indicating whether the calculation should use
the correlation matrix or the covariance matrix. (The correlation matrix
can only be used if there are no constant variables.)}
}
\value{
\code{do_pca} returns a list with class \code{princomp}.
}
\description{
Performs a Principal Components Analysis
}
\examples{
data(path_vals)
pca_model <- do_pca(path_vals[seq_len(ncol(path_vals)),])

}
