% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{create_report}
\alias{create_report}
\title{Create visualization HTML}
\usage{
create_report(
  comp,
  metaginfo,
  output_folder = NULL,
  path = NULL,
  node_colors = NULL,
  group_by = "pathway",
  conf = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{comp}{Comparison object as given by the \code{do_wilcoxon} function}

\item{metaginfo}{Pathways object as returned by the \code{load_pathways}
function}

\item{output_folder}{Name of the folder in which the report will be stored.}

\item{path}{Absolute path to the parent directory in which `output_folder`
will be saved. If it is not provided, it will be created in a temp folder.}

\item{node_colors}{List of colors with which to paint the nodes of the
pathways, as returned by the
\code{node_color_per_de} function. Default is white.}

\item{group_by}{How to group the subpathways to be visualized. By default
they are grouped by the pathway to which they belong. Available groupings
include "uniprot", to group subpathways by their annotated Uniprot functions,
"GO", to group subpathways by their annotated GO terms, and "genes", to group
subpathways by the genes they include. Default is set to "pathway".}

\item{conf}{Level of significance. By default 0.05.}

\item{verbose}{Boolean, whether to show details about the results of the
execution}
}
\value{
Saves the results and creates a report to visualize them through
a server in the specified \code{output_folder}. Returns the folder where
the report has been stored.
}
\description{
Saves the results of a Wilcoxon comparison for the Hipathia pathway values
into a folder, and creates a HTML from which to visualize the results on
top of the pathways. The results are stored into the specified folder.
If this folder does not exist, it will be created. The parent folder must
exist.
}
\examples{
data(comp)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
report <- create_report(comp, pathways, "save_results")

\dontrun{
data(results)
data(brca)
sample_group <- colData(brca)[,1]
colors_de <- node_color_per_de(results, pathways,
sample_group, "Tumor", "Normal")
report_colors <- create_report(comp, pathways, "save_results",
node_colors = colors_de)
}

}
