% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devel.R
\name{DAtop}
\alias{DAtop}
\title{Lists and plots the top \code{n} altered nodes, paths and functions (Uniprot
keywords and/or GO terms, if present).}
\usage{
DAtop(DAdata, n = 10, conf.level = 0.05, adjust = TRUE, colors = "hiro")
}
\arguments{
\item{DAdata}{List of comparison results, returned by function \code{DAcomp}.}

\item{n}{Number of top features to show.}

\item{conf.level}{Numeric, cut off for significance. Default is 0.05.}

\item{adjust}{Boolean, whether to adjust the p.value with
Benjamini-Hochberg FDR method. Default is TRUE.}

\item{colors}{String with the color scheme or vector of colors to be used.
See  \code{define_colors} for available options. Default is "hiro".}
}
\value{
Plot and list of tables including top \code{n} altered features for
nodes, paths and functions if present.
}
\description{
Lists and plots the top \code{n} altered nodes, paths and functions (Uniprot
keywords and/or GO terms, if present).
}
\examples{
data(DAdata)
DAtop(DAdata)

}
