% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devel.R
\name{DAsummary}
\alias{DAsummary}
\title{Lists and plots the top \code{n} altered pathways, taking into account the
number of altered .}
\usage{
DAsummary(
  DAdata,
  n = 10,
  conf.level = 0.05,
  adjust = TRUE,
  ratio = FALSE,
  colors = "hiro",
  order.by = "number"
)
}
\arguments{
\item{DAdata}{List of comparison results, returned by function \code{DAcomp}.}

\item{n}{Number of top features to show.}

\item{conf.level}{Numeric, cut off for significance. Default is 0.05.}

\item{adjust}{Boolean, whether to adjust the p.value with
Benjamini-Hochberg FDR method. Default is TRUE.}

\item{ratio}{Boolean, whether to plot the ratio of significant paths with
respect to the total paths in the pathway. Default is FALSE.}

\item{colors}{String with the color scheme or vector of colors to be used.
See  \code{define_colors} for available options. Default is "hiro".}

\item{order.by}{String, how to order table of results. Available options
include \code{ratio} (default, uses the ratio of significant paths with
respect to the total paths in the pathway) and \code{number} (uses the number
of significant paths in the pathway).}
}
\value{
Plot and tibble including top \code{n} altered pathways.
}
\description{
Lists and plots the top \code{n} altered pathways, taking into account the
number of altered .
}
\examples{
data(DAdata)
DAsummary(DAdata)

}
