% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devel.R
\name{DAreport}
\alias{DAreport}
\title{Create visualization HTML}
\usage{
DAreport(
  DAdata,
  pathways,
  conf.level = 0.05,
  adjust = TRUE,
  group_by = "pathway",
  colors = "classic",
  output_folder = NULL,
  path = NULL,
  verbose = TRUE
)
}
\arguments{
\item{DAdata}{List of comparison results, returned by function \code{DAcomp}.}

\item{pathways}{Pathways object as returned by the \code{load_pathways}
function}

\item{conf.level}{Level of significance. By default 0.05.}

\item{adjust}{Boolean, whether to adjust the p.value with
Benjamini-Hochberg FDR method. Default is TRUE.}

\item{group_by}{How to group the subpathways to be visualized. By default
they are grouped by the pathway to which they belong. Available groupings
include "uniprot", to group subpathways by their annotated Uniprot functions,
"GO", to group subpathways by their annotated GO terms, and "genes", to group
subpathways by the genes they include. Default is set to "pathway".}

\item{colors}{String with the color scheme or vector of colors to be used.
See  \code{define_colors} for available options. Default is "hiro".}

\item{output_folder}{Name of the folder in which the report will be stored.}

\item{path}{Absolute path to the parent directory in which `output_folder`
will be saved. If it is not provided, it will be created in a temp folder.}

\item{verbose}{Boolean, whether to show details about the results of the
execution}
}
\value{
Saves the results and creates a report to visualize them through
a server in the specified \code{output_folder}. Returns the folder where
the report has been stored.
}
\description{
Saves the results of a DAdata comparison for the Hipathia pathway values
into a folder, and creates a HTML from which to visualize the results on
top of the pathways. The results are stored into the specified folder.
If this folder does not exist, it will be created. The parent folder must
exist.
}
\examples{
data(DAdata)
data(pathways)
DAreport(DAdata, pathways)

}
