% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devel.R
\name{DAoverview}
\alias{DAoverview}
\title{Table and plot of total number of altered and not altered nodes, paths and
functions (Uniprot keywords and/or GO terms, if present).}
\usage{
DAoverview(DAdata, conf.level = 0.05, adjust = TRUE, colors = "hiro")
}
\arguments{
\item{DAdata}{List of comparison results, returned by function \code{DAcomp}.}

\item{conf.level}{Numeric, cut off for significance. Default is 0.05.}

\item{adjust}{Boolean, whether to adjust the p.value with
Benjamini-Hochberg FDR method. Default is TRUE.}

\item{colors}{String with the color scheme or vector of colors to be used.
See  \code{define_colors} for available options. Default is "hiro".}
}
\value{
Plot and tibble including the number of total, altered, UP- and
DOWN-regulated features for nodes, paths and functions if present.
}
\description{
Table and plot of total number of altered and not altered nodes, paths and
functions (Uniprot keywords and/or GO terms, if present).
}
\examples{
data(DAdata)
DAoverview(DAdata)

}
