% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devel.R
\name{DAcomp}
\alias{DAcomp}
\title{Compares the gene expression, pathway activation level and the function
activation level of the}
\usage{
DAcomp(
  hidata,
  groups,
  expdes,
  g2 = NULL,
  path.method = "wilcoxon",
  node.method = "limma",
  fun.method = "wilcoxon",
  order = FALSE,
  paired = FALSE,
  adjust = TRUE,
  conf.level = 0.05,
  sel_assay = 1
)
}
\arguments{
\item{hidata}{Either a SummarizedExperiment object or a matrix, returned by
function \code{hipathia}.}

\item{groups}{Either a character indicating the name of the column in colData
including the classes to compare, or a character vector with the class to
which each sample belongs.
Samples must be ordered as in \code{hidata}.}

\item{expdes}{String, either an equation expression to pas to \code{limma},
or the label of the first group to be compared}

\item{g2}{String, label of the second group to be compared, if not specified
in \code{expdes}.}

\item{path.method}{String, method to be used when comparing pathways.
Options include \code{wilcoxon} (default, performs a Wilcoxon test comparing
conditions \code{expdes} and \code{g2} - in this case, mandatory parameter)
and \code{limma} (performs a limma DE analysis using functions \code{lmFit},
\code{contrasts.fit} and \code{eBayes} using the formula in \code{expdes} or
comparing conditions \code{expdes} and \code{g2}.}

\item{node.method}{String, method to be used when comparing nodes.
Options include \code{wilcoxon} (performs a Wilcoxon test comparing
conditions \code{expdes} and \code{g2} - in this case, mandatory parameter)
and \code{limma} (default, performs a limma DE analysis using functions
\code{lmFit}, \code{contrasts.fit} and \code{eBayes} using the formula in
\code{expdes} or comparing conditions \code{expdes} and \code{g2}.}

\item{fun.method}{String, method to be used when comparing functions.
Options include \code{wilcoxon} (default, performs a Wilcoxon test comparing
conditions \code{expdes} and \code{g2} - in this case, mandatory parameter)
and \code{limma} (performs a limma DE analysis using functions \code{lmFit},
\code{contrasts.fit} and \code{eBayes} using the formula in \code{expdes} or
comparing conditions \code{expdes} and \code{g2}.}

\item{order}{Boolean, whether to order the results table by the
\code{FDRp.value} column. Default is FALSE.}

\item{paired}{Boolean, whether the samples to be compared are paired.
If TRUE, function \code{wilcoxsign_test} from package \code{coin} is
used. If FALSE, function \code{wilcox.test} from package \code{stats}
is used.}

\item{adjust}{Boolean, whether to adjust the p.value with
Benjamini-Hochberg FDR method. Default is TRUE.}

\item{conf.level}{Numeric, cut off for significance. Default is 0.05.}

\item{sel_assay}{Character or integer, indicating the assay to be normalized
in the SummarizedExperiment. Default is 1.}
}
\value{
List including comparison results for nodes, pathways and functions,
if present.
}
\description{
Compares the gene expression, pathway activation level and the function
activation level of the
}
\examples{
data(hidata)
comp <- DAcomp(hidata, groups = "group", expdes = "Tumor", g2 = "Normal")

}
