% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compute.r2.R
\name{compute.r2}
\alias{compute.r2}
\title{R2 computation}
\usage{
compute.r2(x, y, res.multisplit, covar = NULL, SNP_index = NULL)
}
\arguments{
\item{x}{The input matrix, of dimension \code{nobs x nvar}. Each row
represents a subject, each column a SNP.}

\item{y}{The response vector. It can be continuous or discrete.}

\item{res.multisplit}{The output of \code{multisplit}.}

\item{covar}{\code{NULL} or the matrix of covariates one wishes to control
for, of size \code{nobs x ncovar}.}

\item{SNP_index}{\code{NULL} or the index vector of the cluster of SNPs whose R2 will be
computed. See the 'Details' section.}
}
\value{
The R2 value of the SNP cluster
}
\description{
Calculates the R2 of a cluster of SNPs.
}
\details{
The R2 of a cluster of SNPs is computed on the second half-samples.
The cluster members, are intersected with the SNPs selected by the lasso, and
the R2 of this model is calculated. Thus, we obtain B R2 values. Finally, the
mean of these values is taken. If the value of \code{SNP_index} is \code{NULL}, the R2 of the full
model with all the SNPs will be computed.
}
\examples{
library(MASS)
x <- mvrnorm(60,mu = rep(0,60), Sigma = diag(60))
beta <- rep(0,60)
beta[c(5,9,3)] <- 1
y <- x \%*\% beta + rnorm(60)
SNP_index <- c(5,9,3)
res.multisplit <- multisplit(x, y)
r2 <- compute.r2(x, y, res.multisplit, SNP_index = SNP_index)
}
\references{
Buzdugan, L. et al. (2015), Assessing statistical significance in
predictive genome-wide association studies. (unpublished)
}

