% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cluster.snp.R
\name{cluster.snp}
\alias{cluster.snp}
\title{Hierarchical Clustering of SNP Data}
\usage{
cluster.snp(x = NULL, d = NULL, method = "average", SNP_index = NULL)
}
\arguments{
\item{x}{The SNP data matrix of size \code{nobs x nvar}. Default value is
\code{NULL}}

\item{d}{\code{NULL} or a dissimilarity matrix. See the 'Details' section.}

\item{method}{The agglomeration method to be used. This should be
(an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"},
\code{"single"}, \code{"complete"}, \code{"average"} (= UPGMA),
\code{"mcquitty"} (= WPGMA), \code{"median"} (= WPGMC) or \code{"centroid"}
(= UPGMC). See \code{\link[fastcluster]{hclust}} for details.}

\item{SNP_index}{\code{NULL} or the index vector of SNPs to be clustered. See
the 'Details' section.}
}
\value{
An object of class \code{\link{dendrogram}} which describes the tree
produced by the clustering algorithm \code{\link[fastcluster]{hclust}}.
}
\description{
Clusters SNPs hierachically.
}
\details{
The SNPs are clustered using \code{\link[fastcluster]{hclust}},
which performs a hierarchical cluster analysis using a set of dissimilarities
for the \code{nvar} objects being clustered. There are 3 possible scenarios.

If \code{d = NULL}, \code{x} is used to compute the dissimilarity matrix.
The dissimilarity measure between two SNPs is \code{1 - LD} (Linkage
Disequilibrium), where \code{LD} is defined as the square of the Pearson
correlation coefficient. If \code{SNP_index = NULL}, all \code{nvar} SNPs will
be clustered; otherwise only the SNPs with indices specified by \code{SNP_index}
will be considered.

If the user wishes to use a different dissimilarity measure, \code{d} needs
to be provided. \code{d} must be either a square matrix of size
\code{nvar x nvar}, or an object of class \code{\link{dist}}. If \code{d} is
provided, \code{x} and \code{SNP_index} will be ignored.
}
\examples{
library(MASS)
x <- mvrnorm(60,mu = rep(0,60), Sigma = diag(60))
clust.1 <- cluster.snp(x = x, method = "average")
SNP_index <- seq(1,10)
clust.2 <- cluster.snp(x = x, method = "average", SNP_index = SNP_index)
d <- dist(x)
clust.3 <- cluster.snp(d = d, method = "single")
}

