% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{h_ensembl_to_entrez_ids}
\alias{h_ensembl_to_entrez_ids}
\title{Translation of \code{Ensembl} to \code{Entrez} Gene IDs}
\usage{
h_ensembl_to_entrez_ids(gene_ids, mart)
}
\arguments{
\item{gene_ids}{(\code{character})\cr \code{Ensembl} gene IDs.}

\item{mart}{(\code{Mart})\cr given \code{\link[biomaRt:Mart-class]{biomaRt::Mart}} object.}
}
\value{
Character vector of \code{Entrez} gene IDs.
}
\description{
This helper function queries \code{BioMart} to translate \code{Ensembl} to \code{Entrez} Gene IDs.
}
\examples{
if (interactive()) {
  mart <- biomaRt::useMart("ensembl", dataset = "hsapiens_gene_ensembl")
  h_ensembl_to_entrez_ids(c("ENSG00000135407", "ENSG00000241644"), mart)
}
}
