% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cut_quantile}
\alias{cut_quantile}
\title{Cutting a Numeric Vector into a Factor of Quantile Bins}
\usage{
cut_quantile(x, percentiles = c(1/3, 2/3), digits = 0)
}
\arguments{
\item{x}{(\code{numeric})\cr the continuous variable values which should be cut into quantile bins. \code{NA} values are
not taken into account when computing quantiles and are attributed to the \code{NA} interval.}

\item{percentiles}{(\code{proportions})\cr the required percentiles for the quantile intervals
to be generated. Duplicated values are removed.}

\item{digits}{(\code{integer})\cr  the precision to use when formatting the percentages.}
}
\value{
The factor with a description of the available quantiles as levels.
}
\description{
This function transforms a numeric vector into a factor corresponding to the quantile intervals.
The intervals are left-open and right-closed.
}
\examples{
set.seed(452)
x <- runif(10, -10, 10)
cut_quantile(x, c(0.33333333, 0.6666666), digits = 4)

x[1:4] <- NA
cut_quantile(x)
}
