% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R
\name{counts,AnyHermesData-method}
\alias{counts,AnyHermesData-method}
\alias{counts}
\alias{counts<-,AnyHermesData,matrix-method}
\title{Counts Accessor and Setter}
\usage{
\S4method{counts}{AnyHermesData}(object, ...)

\S4method{counts}{AnyHermesData,matrix}(object, ..., withDimnames = TRUE) <- value
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr object to access the counts from.}

\item{...}{not used.}

\item{withDimnames}{(\code{flag})\cr setting \code{withDimnames =FALSE} in the setter
(\verb{counts<-}) is required when the \code{dimnames} on the supplied counts assay
are not identical to the \code{dimnames} on the \code{AnyHermesData} object;
it does not influence actual assignment of \code{dimnames} to the assay
(they're always stored as-is).}

\item{value}{(\code{matrix})\cr what should the counts assay be replaced with.}
}
\value{
The counts assay.
}
\description{
These methods access and set the counts assay in a \code{\link{AnyHermesData}} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{counts(object = AnyHermesData) <- value}: 

}}
\examples{
a <- hermes_data
result <- counts(a)
class(result)
head(result)
counts(a) <- counts(a) + 100L
head(counts(a))
}
