% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R
\name{cbind}
\alias{cbind}
\title{Column Binding of \code{AnyHermesData} Objects}
\arguments{
\item{...}{(\code{AnyHermesData})\cr objects to column bind.}
}
\value{
The combined \code{\link{AnyHermesData}} object.
}
\description{
This method combines \code{\link{AnyHermesData}} objects with the same ranges but different
samples (columns in assays).
}
\note{
\itemize{
\item Note that this just inherits
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::cbind,SummarizedExperiment-method()}}. When binding a
\code{\link{AnyHermesData}} object with a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}}
object, then the result will be a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}} object (the more general
class).
\item Note that the combined object needs to have unique sample IDs (column names).
}
}
\examples{
a <- hermes_data[, 1:10]
b <- hermes_data[, 11:20]
result <- cbind(a, b)
class(result)
}
\seealso{
\code{\link{rbind}} to row bind objects.
}
