% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_cor.R
\docType{class}
\name{correlate,AnyHermesData-method}
\alias{correlate,AnyHermesData-method}
\alias{calc_cor}
\alias{HermesDataCor-class}
\alias{.HermesDataCor}
\alias{HermesDataCor}
\alias{autoplot,HermesDataCor-method}
\title{Correlation between Sample Counts of \code{AnyHermesData}}
\usage{
\S4method{correlate}{AnyHermesData}(object, assay_name = "counts", method = "pearson", ...)

\S4method{autoplot}{HermesDataCor}(
  object,
  flag_colors = c(`FALSE` = "green", `TRUE` = "red"),
  cor_colors = circlize::colorRamp2(c(0, 0.5, 1), c("red", "yellow", "green")),
  ...
)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr object to calculate the correlation.}

\item{assay_name}{(\code{string})\cr the name of the assay to use.}

\item{method}{(\code{string})\cr the correlation method, see \code{\link[stats:cor]{stats::cor()}} for details.}

\item{...}{other arguments to be passed to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}.}

\item{flag_colors}{(named \code{character})\cr a vector that specifies the colors for \code{TRUE} and \code{FALSE}
flag values.}

\item{cor_colors}{(\code{function})\cr color scale function for the correlation values in the heatmap,
produced by \code{\link[circlize:colorRamp2]{circlize::colorRamp2()}}.}
}
\value{
A \code{\link{HermesDataCor}} object.
}
\description{
The \code{correlate()} method can calculate the correlation matrix between the sample vectors of
counts from a specified assay. This produces a \code{\link{HermesDataCor}} object, which is an extension
of a \code{\link{matrix}} with additional quality flags in the slot \code{flag_data}
(containing the \code{tech_failure_flag} and \code{low_depth_flag} columns describing the original
input samples).

An \code{autoplot()} method then afterwards can produce the corresponding heatmap.
}
\section{Functions}{
\itemize{
\item \code{autoplot(HermesDataCor)}: This \code{autoplot()} method uses the \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}} function
to plot the correlations between samples saved in a \code{\link{HermesDataCor}} object.

}}
\examples{
object <- hermes_data

# Calculate the sample correlation matrix.
correlate(object)

# We can specify another correlation coefficient to be calculated.
result <- correlate(object, method = "spearman")

# Plot the correlation matrix.
autoplot(result)

# We can customize the heatmap.
autoplot(result, show_column_names = FALSE, show_row_names = FALSE)

# Including changing the axis label text size.
autoplot(
  result,
  row_names_gp = grid::gpar(fontsize = 8),
  column_names_gp = grid::gpar(fontsize = 8)
)
}
