% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Heatmap-class.R
\docType{class}
\name{Heatmap-class}
\alias{Heatmap-class}
\title{An S4 class to represent a heatmap}
\description{
An S4 class to represent a heatmap
}
\section{Slots}{

\describe{
\item{\code{image}}{A numeric Matrix}

\item{\code{scale}}{A length-2 vector}

\item{\code{coords}}{A length-2 integer vector}

\item{\code{nseq}}{An integer}

\item{\code{label}}{A character vector}

\item{\code{metadata}}{A list containing arbitrary metadata

A class used to represent a heatmap in a simple, self-contained way

Slots can be accessed and set using getters and setters with the same name.}
}}

\examples{

data(HeatmapExamples)

hm = new("Heatmap",
         image=mat,
         scale=c(0,max(mat)),
         coords=c(-100L, 100L),
         nseq=1000L,
         label="Test",
         metadata=list())

# or use the constructor:
hm = Heatmap(mat, coords=c(-100, 100), label="Test")
}
\seealso{
CoverageHeatmap PatternHeatmap plotHeatmap plotHeatmapMeta
}
