% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_hca.R
\name{hca_next.tbl_hca}
\alias{hca_next.tbl_hca}
\alias{hca_prev.tbl_hca}
\title{'tibble' representation of HCA query results}
\usage{
\method{hca_next}{tbl_hca}(x, size)

\method{hca_prev}{tbl_hca}(x, size)
}
\arguments{
\item{x}{a 'tibble' returned by \code{projects()}, \code{samples()},
\code{files()}, or \code{bundles()}.}

\item{size}{the (non-negative integer) number of elements to
retrieve in the page request. The default is the number of
elements requested in \code{x}.}
}
\value{
\code{hca_next()} returns a tibble, with the same columns as
\code{x}, containing the next 'page' of results.

\code{hca_prev()} returns a tibble with the same columns as \code{x},
containing the previous 'page' of results.
}
\description{
\code{projects()}, \code{samples()}, \code{files()}, and \code{bundles()}
return, by default, a 'tibble' representation of the
query.

\code{hca_next()} returns the next 'page' of results, if
available.

\code{hca_prev()} returns the previous 'page' of results.
}
\examples{
projects <- projects(size = 5)      # projects 1-5
next_projects <- hca_next(projects) # projects 6-10

hca_prev(next_projects)             # projects 1-5

}
