% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\title{Repository summary statistics}
\usage{
summary(
  filters = NULL,
  type = c("overview", "fileTypeSummaries", "cellCountSummaries", "organTypes", "list"),
  catalog = NULL
)
}
\arguments{
\item{filters}{filter object created by \code{filters()}, or \code{NULL}
(default; all projects).}

\item{type}{character(1) type of summary to return. Possible values
include "overview", "fileTypeSummaries", "cellCountSummaries",
"organType", and a "list" off all summary statistics.}

\item{catalog}{character(1) source of data. Use
\code{catalogs()} for possible values.}
}
\value{
\code{summary()} returns a tibble or (for \code{type = "list"}) a
list-of-lists of summary statistics.
}
\description{
\code{summary()} provides numerical summaries of catalog content
}
\examples{
hca::summary()

filter <- filters(
    organ = list(is = c("brain", "heart")),
    genusSpecies = list(is = "Homo sapiens")
)
hca::summary(filter)
hca::summary(filter, "fileTypeSummaries")
hca::summary(filter, "cellCountSummaries")

}
