% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samples.R
\name{samples}
\alias{samples}
\alias{samples_facets}
\alias{samples_default_columns}
\alias{samples_detail}
\title{HCA Sample Querying}
\usage{
samples(
  filters = NULL,
  size = 1000L,
  sort = "projectTitle",
  order = c("asc", "desc"),
  catalog = NULL,
  as = c("tibble", "lol", "list", "tibble_expanded"),
  columns = samples_default_columns("character")
)

samples_facets(facet = character(), catalog = NULL)

samples_default_columns(as = c("tibble", "character"))

samples_detail(uuid, catalog = NULL)
}
\arguments{
\item{filters}{filter object created by \code{filters()}, or \code{NULL}
(default; all projects).}

\item{size}{integer(1) maximum number of results to return;
default: all projects matching \code{filter}. The default (10000) is
meant to be large enough to return all results.}

\item{sort}{character(1) project facet (see \code{facet_options()}) to
sort result; default: \code{"projectTitle"}.}

\item{order}{character(1) sort order. One of \code{"asc"} (ascending) or
\code{"desc"} (descending).}

\item{catalog}{character(1) source of data. Use
\code{catalogs()} for possible values.}

\item{as}{character(1) return format. One of \code{"tibble"} (default),
\code{"lol"}, \code{"list"}, or \code{"tibble_expanded"}, as described in the
Details and Value sections of \code{?projects}.}

\item{columns}{named character() indicating the paths to be used
for parsing the 'lol' returned from the HCA to a tibble. The
names of \code{columns} are used as column names in the returned
tibble. If the columns are unnamed, a name is derived from the
elements of \code{path} by removing \verb{hits[*]} and all \verb{[*]}, e.g., a
path \verb{hits[*].donorOrganisms[*].biologicalSex[*]} is given the
name \code{donorOrganisms.biologicalSex}.}

\item{facet}{character() of valid facet names. Summary results (see
'Value', below) are returned when missing or length greater
than 1; details are returned when a single facet is specified.}

\item{uuid}{character() unique identifier (e.g., \code{projectId}) of
the object.}
}
\value{
\code{samples_detail()} returns a list-of-lists containing
relevant details about the sample
}
\description{
\code{samples()} takes a list of user provided project titles
to be used to query the HCA API for information about available samples.

\code{samples_detail()} takes a unique sample_id and catalog for
the sample, and returns details about the specified sample as a
list-of-lists
}
\examples{
title <- paste(
    "Tabula Muris: Transcriptomic characterization of 20 organs and",
    "tissues from Mus musculus at single cell resolution"
)
filters <- filters( projectTitle = list(is = title) )
samples(filters = filters)

samples_facets()

sample <- samples(size = 1, as = "list")
sample_uuid <- sample[["hits"]][[1]][["entryId"]]
samples_detail(uuid = sample_uuid)

}
