% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{projects}
\alias{projects}
\alias{projects_facets}
\alias{projects_default_columns}
\alias{projects_detail}
\title{HCA Project Querying}
\usage{
projects(
  filters = NULL,
  size = 1000L,
  sort = "projectTitle",
  order = c("asc", "desc"),
  catalog = NULL,
  as = c("tibble", "lol", "list", "tibble_expanded"),
  columns = projects_default_columns("character")
)

projects_facets(facet = character(), catalog = NULL)

projects_default_columns(as = c("tibble", "character"))

projects_detail(uuid, catalog = NULL)
}
\arguments{
\item{filters}{filter object created by \code{filters()}, or \code{NULL}
(default; all projects).}

\item{size}{integer(1) maximum number of results to return;
default: all projects matching \code{filter}. The default (10000) is
meant to be large enough to return all results.}

\item{sort}{character(1) project facet (see \code{facet_options()}) to
sort result; default: \code{"projectTitle"}.}

\item{order}{character(1) sort order. One of \code{"asc"} (ascending) or
\code{"desc"} (descending).}

\item{catalog}{character(1) source of data. Use
\code{catalogs()} for possible values.}

\item{as}{character(1) return format. One of \code{"tibble"} (default),
\code{"lol"}, \code{"list"}, or \code{"tibble_expanded"}, as described in the
Details and Value sections of \code{?projects}.}

\item{columns}{named character() indicating the paths to be used
for parsing the 'lol' returned from the HCA to a tibble. The
names of \code{columns} are used as column names in the returned
tibble. If the columns are unnamed, a name is derived from the
elements of \code{path} by removing \verb{hits[*]} and all \verb{[*]}, e.g., a
path \verb{hits[*].donorOrganisms[*].biologicalSex[*]} is given the
name \code{donorOrganisms.biologicalSex}.}

\item{facet}{character() of valid facet names. Summary results (see
'Value', below) are returned when missing or length greater
than 1; details are returned when a single facet is specified.}

\item{uuid}{character() unique identifier (e.g., \code{projectId}) of
the object.}
}
\value{
When \code{as = "tibble"} or \code{as = "tibble_expanded"}, a tibble
with each row representing an HCA object (project, sample,
bundle, or file, depending on the function invoked), and
columns summarizing the object. \code{"tibble_expanded"} columns
contains almost all information about the object, except as
noted in the Details section.

When \code{as = "lol"}, a list-of-lists data structure representing
detailed information on each object.

When \code{as = "list"}, \code{projects()} returns an R list, typically
containing other lists or atomic vectors, representing detailed
information on each project.

\code{projects_facets()} invoked with no \verb{facet=} argument returns a
tibble summarizing terms available as \code{projects()} return
values, and for use in filters. The tibble contains columns
\itemize{
\item \code{facet}: the name of the facet.
\item \code{n_terms}: the number of distinct values the facet can take.
\item \code{n_values}: the number of occurrences of the facet term in the
entire catalog.
}

\code{projects_facets()} invoked with a scalar value for \verb{facet=}
returns a tibble summarizing terms used in the facet, and the
number of occurrences of the term in the entire catalog.

\verb{*_columns()} returns a tibble with column \code{name}
containing the column name used in the tibble returned by
\code{projects()}, \code{files()}, \code{samples()}, or \code{bundles()}, and
\code{path} the path (see \code{lol_hits()}) to the data in the
list-of-lists by the same functions when \code{as = "lol"}. When \code{as = "character"}, the return value is a named list with paths as
elements and abbreviations as names.

list-of-lists containing relevant details about the project.
}
\description{
\code{projects()} takes user input to be used to query the
HCA API for information about available projects.

\code{projects_facets()} summarizes facets and terms used by
all records in the projects index.

\verb{*_columns()} returns a tibble or named
character vector describing the content of the tibble returned
by \code{projects()}, \code{files()}, \code{samples()}, or \code{bundles()}.

\code{projects_detail()} takes a unique project_id and catalog for
the project, and returns details about the specified project as a
list-of-lists

See \code{project_information()} and \code{project_title()} to
easily summarize a project from its project id.
}
\details{
The \code{as} argument determines the object returned by the
function. Possible values are:
\itemize{
\item "tibble" (default) A tibble (data.frame) summarizing essential
elements of projects, samples, bundles, or files.
\item "lol" A 'list-of-lists' representation of the JSON returned by
the query as a 'list-of-lists' data structure, indexed and
presented to enable convenient filtering, selection, and
extraction. See \code{?lol}.
\item "list" An R list (typically, highly recursive) containing
detailed project information, constructed from the JSON response
to the original query.
\item "tibble_expanded" A tibble (data.frame) containing (almost) all
information for each project, sample, bundle, or file. The
exception is user-contributed matrices present in \code{projects()}
records; these must be accessed using the \code{"lol"} format to
extract specific paths as a standard \code{"tibble"}.
}
}
\examples{
projects(filters(), size = 100)

projects_facets()
projects_facets("genusSpecies")

projects_default_columns()

project <- projects(size = 1, as = "list")
project_uuid <- project[["hits"]][[1]][["entryId"]]
projects_detail(uuid = project_uuid)

}
\seealso{
\code{project_information()} and \code{project_title()} to easily
summarize a project from its project id.

\code{lol()} and other \verb{lol_*()} functions for working with the
list-of-list data structure returned when \code{as = "lol"}.
}
