% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_information.R
\name{project_information}
\alias{project_information}
\alias{project_title}
\alias{print.project_information}
\title{Project Summaries from Project IDs}
\usage{
project_information(project_id)

project_title(project_id)

\method{print}{project_information}(x, ...)
}
\arguments{
\item{project_id}{\code{character(1)} project identifier, e.g.,
\code{"3c9d586e-bd26-4b46-8690-3faaa18ccf38"}.}

\item{x}{an object of class \code{project_information}, the result of a
call to \code{project_information()}.}

\item{...}{additional arguments, required to conform with the
\code{print} generic but not used.}
}
\value{
\code{project_information()} returns a tibble with a single row,
and columns containing information about the project. The
tibble is of class \code{project_information} and is printed in an
interactive session formatted so long columns, e.g.,
\code{projectDescription}, are more easily read.

\code{project_title()} returns a character(1) vector containing
the project title.

\code{print.project_information()} is invoked automatically when
the result of \code{project_information()} is displayed for it's
side effect of displaying the object.
}
\description{
\code{project_information()} queries the HCA database for
project title, description, contact, DOI, and publication URI.

\code{project_title()} returns the title of the project,
cleaned to remove trailing trailing \code{.}.

\code{print.project_information()} formats the result of
\code{project_information()} in a more legible manner.
}
\examples{
project_id <- "3c9d586e-bd26-4b46-8690-3faaa18ccf38"
project_information(project_id)

project_title(project_id)

}
