% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimus_loom_annotation.R
\name{optimus_loom_annotation}
\alias{optimus_loom_annotation}
\alias{optimus_loom_annotation.character}
\alias{optimus_loom_annotation.LoomExperiment}
\title{HCA loom file annotation}
\usage{
optimus_loom_annotation(loom, catalog = NULL)

\method{optimus_loom_annotation}{character}(loom, catalog = NULL)

\method{optimus_loom_annotation}{LoomExperiment}(loom, catalog = NULL)
}
\arguments{
\item{loom}{Either a character(1) file path to a loom file on
user's system, or a loom file obtained from the HCA and
imported into R using \code{LoomExperiment::import()}.}

\item{catalog}{character() HCA catalog from which the .loom file
originated.}
}
\value{
A 'LoomExperiment' object annotated with additional
\code{metadata()} and \code{colData()} derived from the manifest file
describing samples in the object.
}
\description{
\code{optimus_loom_annotation()} takes the file path
location of a .loom file generated by the Optimus pipeline, for
which additional data will be extracted from the appropriate
manifest.  The .loom file will be imported as a LoomExperiment
object, and the additional manifest information will be added
to the object for return.
}
\seealso{
\code{manifest()} and related functions for working with data
returned from the \verb{*/manifest/*} HCA API endpoints.
}
