% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifest.R
\name{manifest}
\alias{manifest}
\alias{manifest_cache}
\title{HCA File Querying}
\usage{
manifest(filters = NULL, catalog = NULL, update_cache = FALSE)

manifest_cache(create = FALSE)
}
\arguments{
\item{filters}{hca filter object}

\item{catalog}{character() name of catalog}

\item{update_cache}{logical(1) when \code{TRUE}, update an existing
cached resource by querying the HCA data server.}

\item{create}{logical(1) create the default cache location, if it
does not yet exist.}
}
\value{
\code{manifest_cache()} returns the path to the default cache. Use
this as the \verb{cache=} argument to \code{BiocFileCache()}.
}
\description{
\code{manifest()} takes a list of user provided project
titles to be used to query the HCA API for information about
available manifest files.

\code{manifest_cache()} is the default location of the cache
of downloaded manifest.
}
\details{
\code{manifest_cache()} can be useful when it is necessary to
'clean up' the cache, e.g., \code{BiocFileCache::cleanbfc()} or more
dramatically \code{unlink(manifest_cache(), recursive = TRUE)}.
}
\examples{
manifest_filter <- hca::filters(
    projectId = list(is = "4a95101c-9ffc-4f30-a809-f04518a23803"),
    fileFormat = list(is = "loom"),
    workflow = list(is = c("optimus_v4.2.2", "optimus_v4.2.3"))
)
\dontrun{
result <- manifest(manifest_filter)
result
}
manifest_cache(create = FALSE)
}
