% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lol.R, R/lol_hits.R
\name{lol}
\alias{lol}
\alias{lol_select}
\alias{lol_filter}
\alias{lol_lpull}
\alias{lol_pull}
\alias{lol_path}
\alias{as.list.lol}
\alias{print.lol}
\alias{hca_next.lol_hca}
\alias{hca_prev.lol_hca}
\alias{lol_hits_lpull}
\alias{lol_hits_pull}
\title{Representing and manipulating list-of-list data structures.}
\usage{
lol(x = list())

lol_select(x, path = character())

lol_filter(x, ...)

lol_lpull(x, path)

lol_pull(x, path)

lol_path(x)

\method{as.list}{lol}(x, ...)

\method{print}{lol}(x, ...)

\method{hca_next}{lol_hca}(x, size)

\method{hca_prev}{lol_hca}(x, size)

lol_hits_lpull(x, path)

lol_hits_pull(x, path)
}
\arguments{
\item{x}{a 'list-of-lists' returned by \code{projects()}, \code{samples()},
\code{files()}, or \code{bundles()}}

\item{path}{character(1) from the tibble returned by \code{lol_path(x)}.}

\item{...}{for \code{lol_filter()}, named filter expressions
evaluating to a logical vector with length equal to the number
of rows in \code{lol_path()}.}

\item{size}{the (non-negative integer) number of elements to
retrieve in the page request. The default is the number of
elements requested in \code{x}.}
}
\value{
\code{lol()} returns a representation of the list-of-lists. The
list has been processed to a dictionary with entries to all
paths through the list, as well as a tibble summarizing the
path, number of occurrences, and leaf status of each unique
path.

\code{lol_select()} returns an object of class \code{"lol"} subset
to contain just the elements matching \code{path} as 'top-level'
elements of the list-of-lists.

\code{lol_filter()} returns an object of class \code{lol}, filtered
to contain elements consistent with the filter criteria.

\code{lol_lpull()} returns a list, where each element
corresponds to an element found at \code{path} in the list-of-lists
structure \code{x}.

\code{lol_pull()} returns an unnamed vector of elements matching
\code{key}.

\code{hca_next()} returns a list-of-lists containing the next
'page' of results.

\code{hca_prev()} returns a tibble with the same columns as \code{x},
containing the previous 'page' of results.
}
\description{
\code{lol()} constructs an indexed representation of an R
'list-of-lists', typically from JSON queries. The object is
conveniently manipulated by other functions on this page to
filter and select subsets of the structure, and to pull
individual paths from across the list-of-lists.

\code{lol_filter()} filters available paths based on
selections in \code{...}, e.g., \code{n} (number of matching elements) or
\code{is_leaf} (is the element a 'leaf' in the list-of-lists
representation?).

\code{lol_lpull()} returns a list containing elements
corresponding to a single \code{path}.

\code{lol_pull()} tries to simplify the list-of-lists
structure returned by \code{lol_lpull()} to a vector.

\code{lol_path()} returns a tibble representing the paths
through the list-of-lists, without the underlying list-of-list
data.

\code{as.list()} returns a list-of-lists representation of
the data returned by \code{projects()}, etc.

\code{hca_next()} returns the next 'page' of results, if
available.

\code{hca_prev()} returns the previous 'page' of results.

\code{lol_hits_lpull()} and \code{lol_hits_pull()} are variants
of \code{lol_lpull()} and \code{lol_pull()} that retain the original
geometry of \verb{hits[*]}, even when the mapping between \verb{hits[*]}
and \code{path} is not 1:1.
}
\examples{
plol <- projects(size = 5, as = "lol")
plol

plol |> lol_select("hits[*].projects[*]")

plol |>
   lol_select("hits[*].projects[*]") |>
   lol_filter(n == 44, is_leaf)

plol |>
    lol_pull("hits[*].entryId") |>
    head()

plol |> lol_path()

projects <- projects(size = 5, as = "lol")     # projects 1-5
next_projects <- hca_next(projects)            # projects 6-10

hca_prev(next_projects)                        # projects 1-5

}
