% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_hca.R
\name{hca_next.list_hca}
\alias{hca_next.list_hca}
\alias{hca_prev.list_hca}
\title{'list' representation of HCA query results}
\usage{
\method{hca_next}{list_hca}(x, size)

\method{hca_prev}{list_hca}(x, size)
}
\arguments{
\item{x}{a 'list' returned by \code{projects()}, \code{samples()}, \code{files()},
or \code{bundles()}.}

\item{size}{the (non-negative integer) number of elements to
retrieve in the page request. The default is the number of
elements requested in \code{x}.}
}
\value{
\code{hca_next()} returns a list containing the next 'page' of
results.

\code{hca_prev()} returns a list containing the previous 'page'
of results.
}
\description{
\code{projects()}, \code{samples()}, \code{files()} and \code{bundles()}
return results for the number of records indicated by the
\verb{size=} argument. Use \code{as = "list"} to return results as a
\code{"list_hca"} list.

\code{hca_next()} returns a list containing the next 'page'
of results.

\code{hca_prev()} returns a list containing the previous
'page' of results.
}
\examples{
projects <- projects(size = 5, as = "list") # projects 1-5
next_projects <- hca_next(projects)         # projects 6-10

hca_prev(next_projects)            # projects 1-5

}
