% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hca.R
\name{hca_next}
\alias{hca_next}
\alias{hca_prev}
\title{Page through HCA results}
\usage{
hca_next(x, size)

hca_prev(x, size)
}
\arguments{
\item{x}{a 'tibble' or 'lol' object returned by \code{projects()},
\code{samples()}, \code{files()}, or \code{bundles()}.}

\item{size}{the (non-negative integer) number of elements to
retrieve in the page request. The default is the number of
elements requested in \code{x}.}
}
\value{
\code{hca_next()} returns the next page of results as a 'tibble'
or 'lol'

\code{hcl_prev()} returns the previous page of results.
}
\description{
\code{hca_next()} retrieves the next 'page' of results from
a query of \code{projects()}, \code{samples()}, \code{files()}, or
\code{bundles()}.

\code{hca_prev()} returns the previous 'page' of results.
}
\examples{
files <- files(size = 5)         # results 1-5, as a tibble

next_files <- hca_next(files)    # results 6-10
next_files

hca_prev(next_files)             # previous results, i.e., files 1-5

}
