% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filters}
\alias{filters}
\alias{facet_options}
\alias{length.filters}
\alias{print.filters}
\title{HCA Filter Construction}
\usage{
facet_options()

filters(...)

\method{length}{filters}(x)

\method{print}{filters}(x, ...)
}
\arguments{
\item{...}{named arguments, each of which is a \code{list()} specifying
a query facet and its corresponding value to be used in the
query}

\item{x}{for \code{length()} and \code{print()}, an object of class \code{filters}.}
}
\value{
\code{facet_options()} returns a vector of all permissible query
facets for the HCA api.

\code{filters()} returns a \code{filters} object representing
validated filters in a format suitable for use in \code{projects()}
and related functions.
}
\description{
\code{facet_options()} returns a character vector of possible facets
to use during filtering.

\code{filters()} takes user input to be used as query
filters. Each named argument is a list with a name specifying a
verb (e.g., \code{"is"}) and a character vector of allowed values,
as in the examples. This input is then validated, reformatted
to JSON, and encoded into a properly formatted URL.
}
\examples{
facet_options()

filters()

filters(
    organ = list(is = "pancreas")
)

filters(
    organ = list(is = "pancreas"),
    genusSpecies = list(is = "Homo sapiens")
)

filters(
    fileFormat = list(is = c("fastq", "fastq.gz"))
)

}
