% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{files}
\alias{files}
\alias{files_default_columns}
\alias{files_download}
\alias{files_facets}
\alias{files_detail}
\alias{files_cache}
\title{HCA File Querying}
\usage{
files(
  filters = NULL,
  size = 1000L,
  sort = "projectTitle",
  order = c("asc", "desc"),
  catalog = NULL,
  as = c("tibble", "lol", "list", "tibble_expanded"),
  columns = files_default_columns("character")
)

files_default_columns(as = c("tibble", "character"))

files_download(tbl, destination = NULL)

files_facets(facet = character(), catalog = NULL)

files_detail(uuid, catalog = NULL)

files_cache(create = FALSE)
}
\arguments{
\item{filters}{filter object created by \code{filters()}, or \code{NULL}
(default; all projects).}

\item{size}{integer(1) maximum number of results to return;
default: all projects matching \code{filter}. The default (10000) is
meant to be large enough to return all results.}

\item{sort}{character(1) project facet (see \code{facet_options()}) to
sort result; default: \code{"projectTitle"}.}

\item{order}{character(1) sort order. One of \code{"asc"} (ascending) or
\code{"desc"} (descending).}

\item{catalog}{character(1) source of data. Use
\code{catalogs()} for possible values.}

\item{as}{character(1) return format. One of \code{"tibble"} (default),
\code{"lol"}, \code{"list"}, or \code{"tibble_expanded"}, as described in the
Details and Value sections of \code{?projects}.}

\item{columns}{named character() indicating the paths to be used
for parsing the 'lol' returned from the HCA to a tibble. The
names of \code{columns} are used as column names in the returned
tibble. If the columns are unnamed, a name is derived from the
elements of \code{path} by removing \verb{hits[*]} and all \verb{[*]}, e.g., a
path \verb{hits[*].donorOrganisms[*].biologicalSex[*]} is given the
name \code{donorOrganisms.biologicalSex}.}

\item{tbl}{tibble of files (result of \code{files()})}

\item{destination}{character() vector name of temporary directory to use
for file downloads, or \code{NULL}}

\item{facet}{character() of valid facet names. Summary results (see
'Value', below) are returned when missing or length greater
than 1; details are returned when a single facet is specified.}

\item{uuid}{character() unique identifier (e.g., \code{projectId}) of
the object.}

\item{create}{logical(1) create the default cache location, if it
does not yet exist.}
}
\value{
\code{files_download()} returns a character() vector of file
destinations

\code{files_detail()} returns a list-of-lists containing
relevant details about the file.

\code{files_cache()} returns the path to the default cache. Use
this as the \verb{cache=} argument to \code{BiocFileCache()}.
}
\description{
\code{files()} takes a list of user provided project titles
to be used to query the HCA API for information about available files.

\code{files_download()} takes a tibble of files and a directory
location as arguments to download the files of the tibble into the specified
directory.

\code{files_detail()} takes a unique file_id and catalog for
the file, and returns details about the specified file as a
list-of-lists

\code{files_cache()} is the default location of the cache
of downloaded files.
}
\details{
\code{files_cache()} can be useful when it is necessary to
'clean up' the cache, e.g., \code{BiocFileCache::cleanbfc()} or more
dramatically \code{unlink(files_cache(), recursive = TRUE)}.
}
\examples{
title <- paste(
    "Tabula Muris: Transcriptomic characterization of 20 organs and",
    "tissues from Mus musculus at single cell resolution"
)
filters <- filters( projectTitle = list(is = title) )
files(filters = filters)

files_filter <- filters(
    projectId = list(is = "cddab57b-6868-4be4-806f-395ed9dd635a"),
    fileFormat = list(is = "loom")
)
files_tbl <- files(filter = files_filter)
\dontrun{files_download(files_tbl, destination = tempdir())}
files_facets()
files_facets("fileFormat")

file <- files(size = 1, as = "list")
file_uuid <- file[["hits"]][[1]][["entryId"]]
files_detail(uuid = file_uuid)

files_cache(create = FALSE)
}
