\name{writeToTallyFile}
\alias{writeToTallyFile}
\title{
Writing data to an HDF5 tally file
}
\description{
This function is used to write the results of a call to \code{\link{tallyRanges}} to an HDF5 tally file.
}
\usage{
writeToTallyFile( theData, file, study, ranges, samples = NULL )
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{theData}{
  A \code{list} of \code{list}s of datasets as returned by a call to e.g. \code{\link{tallyRanges}} 
}
  \item{file}{
  The target filename
}
  \item{study}{
  The location of the Group (within the HDF5 file) representing the study the data belongs to.
}
  \item{ranges}{
  A \code{GRanges} object defining the ranges that the elements of \code{theData} correspond to
  }
  \item{samples}{
  The indexes of the samples that the data corresponds to, this can be extracted from the 'Column'-field in the sample metadata and is used to write data corresponding to subsets of the cohort samples. The default (\code{NULL}) indicates that all samples are present and will be written.
}
}
\author{
Paul Theodor Pyl
}

\examples{
suppressPackageStartupMessages(library("h5vc"))
suppressPackageStartupMessages(library("rhdf5"))
files <- list.files( system.file("extdata", package = "h5vcData"), "Pt.*bam$" )
bamFiles <- file.path( system.file("extdata", package = "h5vcData"), files)
suppressPackageStartupMessages(require(BSgenome.Hsapiens.NCBI.GRCh38))
suppressPackageStartupMessages(require(GenomicRanges))
dnmt3a <- read.table(system.file("extdata", "dnmt3a.txt", package = "h5vcData"), header=TRUE, stringsAsFactors = FALSE)
dnmt3a <- with( dnmt3a, GRanges(seqname, ranges = IRanges(start = start, end = end)))
dnmt3a <- reduce(dnmt3a)
require(BiocParallel)
register(MulticoreParam())
theData <- tallyRanges( bamFiles, ranges = dnmt3a[1:3], reference = Hsapiens )
chrom <- "2"
chromlength <- 250e6
study <- "/DNMT3A"
tallyFile <- file.path( tempdir(), "DNMT3A.tally.hfs5" )
if( file.exists(tallyFile) ){
  file.remove(tallyFile)
}
if( prepareTallyFile( tallyFile, study, chrom, chromlength, nsamples = length(files) ) ){
  h5ls(tallyFile)
}else{
  message( paste( "Preparation of:", tallyFile, "failed" ) )
}
writeToTallyFile(theData, tallyFile, study = "/DNMT3A", ranges = dnmt3a[1:3])
}
