setSampleData <- function( filename, group, sampleData, largeAttributes = FALSE, stringSize = 64 ){
  sampleData$Column = sampleData$Column - 1 # 1-based in R, internally 0-based
  f <- H5Fopen(filename)
  g <- H5Gopen(f, group)
  if( !largeAttributes ){
    if( nrow(sampleData) > 100 ){
      message( "Storing more than 100 rows of sampleData in HDF5 attributes, which are limited in size. Please consider setting 'largeAttributes' to TRUE")
    }
    for( column in colnames(sampleData) ){
      h5writeAttribute( attr = sampleData[[column]], h5obj = g, name = column )
    }
  }else{
    h5writeAttribute( attr = paste( group, "AttributeStorage", sep="/"), h5obj = g, name = "AttributeStorage" )
    if( H5Lexists( g, "AttributeStorage" )){
      ag = H5Gopen( g, "AttributeStorage")  
    }else{
      ag = H5Gcreate( g, "AttributeStorage" )
    }
    for( column in colnames(sampleData)){
      if( is.character(sampleData[[column]]) & !(H5Lexists( f, paste(group, "AttributeStorage", column, sep="/"))) ){
        h5createDataset( filename, paste(group, "AttributeStorage", column, sep="/"), dims = nrow(sampleData), storage.mode="character", size = stringSize)  
      }
      h5writeDataset( obj = sampleData[[column]], h5loc = ag, name = column, index = list(1:nrow(sampleData)))
    }
    H5Gclose(ag)
  }
  H5Gclose(g)
  H5Fclose(f)
}
