% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{riskyAlleleCount}
\alias{riskyAlleleCount}
\title{given a matrix of subjects x SNP calls, count number of risky alleles}
\usage{
riskyAlleleCount(
  callmat,
  matIsAB = TRUE,
  chr,
  gwwl,
  snpap = "SNPlocs.Hsapiens.dbSNP144.GRCh37",
  gencode = c("A/A", "A/B", "B/B")
)
}
\arguments{
\item{callmat}{matrix with subjects as rows, SNPs as columns; entries can be
generic A/A, A/B, B/B, or specific nucleotide calls}

\item{matIsAB}{logical, FALSE if nucleotide codes are present, TRUE if
generic call codes are present; in the latter case, gwascat:::ABmat2nuc will
be run}

\item{chr}{code for chromosome, should work with the SNP annotation
getSNPlocs function, so likely "ch[nn]"}

\item{gwwl}{an instance of \code{{gwaswloc}}}

\item{snpap}{name of a Bioconductor SNPlocs.Hsapiens.dbSNP.* package}

\item{gencode}{codes used for generic SNP call}
}
\value{
matrix with rows corresponding to subjects , columns corresponding
to SNP
}
\description{
given a matrix of subjects x SNP calls, count number of risky alleles for
various conditions, relative to NHGRI GWAS catalog
}
\examples{

\dontrun{
data(gg17N) # translated from GGdata chr 17 calls using ABmat2nuc
data(ebicat37)
library(GenomeInfoDb)
seqlevelsStyle(ebicat37) = "UCSC"
h17 = riskyAlleleCount(gg17N, matIsAB=FALSE, chr="ch17", gwwl=ebicat37)
h17[1:5,1:5]
table(as.numeric(h17))
}

}
\keyword{models}
