% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limitToXkb.R
\name{limitToXkb}
\alias{limitToXkb}
\title{limitToXkb truncates a set of genomic itnervals at a constant, maximum size.}
\usage{
limitToXkb(features, offset = 1000, size = 13000)
}
\arguments{
\item{features}{A GRanges object representing a set of genomic coordinates.
The meta-plot will be centered on the start position.}

\item{offset}{Starts the interval from this position relative to the start
of each genomic features.}

\item{size}{Specifies the size of the window.}
}
\value{
Returns GRanges object with new genomic coordiates.
}
\description{
limitToXkb truncates a set of genomic itnervals at a constant, maximum size.
}
\examples{
tx <- GRanges("chr7", IRanges(1000, 30000), strand="+")
newTX <- limitToXkb(tx)
}
\author{
Minho Chae and Charles G. Danko
}
