% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{getPIPs}
\alias{getPIPs}
\title{Get posterior inclusion probabilities per feature}
\usage{
getPIPs(object)
}
\arguments{
\item{object}{fitted graper model as obtained from  \code{\link{graper}}}
}
\value{
1-Column matrix of estimated posterior inclusion probabilities.
}
\description{
Function to obtain estimated posterior inclusion
 probabilities per feature from a fitted graper model.
}
\examples{
# create data
dat <- makeExampleData()
# fit the graper model to the data
fit <- graper(dat$X, dat$y, dat$annot)
# extract the posterior inclusion probabilities from the fitted model
getPIPs(fit)
}
