% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_regress.R
\name{plot_regress}
\alias{plot_regress}
\title{Plot estimated cell type coefficients against the ground truth}
\usage{
plot_regress(benchmarked, method = "svr", signature = "sig1")
}
\arguments{
\item{benchmarked}{List: output object from function \code{benchmarked}.}

\item{method}{Character string with name of method to be regressed.}

\item{signature}{Character string with name of signature to be regressed.}
}
\value{
Plot showing regression of estimated versus measured cell type 
coefficients.
}
\description{
\code{plot_regress} depicts the measured cell type 
proportions (x-axis) vs. the estimated proportions (y-axis).
}
\examples{
# load demo PBMCS data
load_ABIS()

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix_ABIS_S0)

# bechmark
bench <- benchmark(deconvoluted = decon, 
ground_truth = groundTruth_ABIS)

# plot regress
plot_regress(benchmarked = bench, 
method = 'svr', signature = 'sig1')

}
\author{
Vincent Kuettel, Sabina Pfister
}
