% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_proportions.R
\name{plot_proportions}
\alias{plot_proportions}
\title{Plot estimated cell type proportions}
\usage{
plot_proportions(deconvoluted, method = "svr", signature = "sig1")
}
\arguments{
\item{deconvoluted}{Output object from function \code{deconvolute}.}

\item{method}{Character string with name of method to be regressed.}

\item{signature}{Character string with name of signature to be regressed.}
}
\value{
Plot showing regression of estimated versus measured cell type 
coefficients.
}
\description{
\code{plot_proportions} plots the estimated cell type 
proportions as computed by a given method and signature matrix.
}
\examples{
# load demo PBMCS data
load_ABIS()

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix_ABIS_S0)

# plot cell type proportions
plot_proportions(deconvoluted = decon, 
method = 'svr', signature = 'sig1')

}
\author{
Vincent Kuettel, Sabina Pfister
}
