% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_deconvolute.R
\name{plot_deconvolute}
\alias{plot_deconvolute}
\title{Estimated cell types across methods}
\usage{
plot_deconvolute(
  deconvoluted = deconvoluted,
  scale = TRUE,
  labels = TRUE,
  markers = TRUE
)
}
\arguments{
\item{deconvoluted}{output object from function \code{deconvolute}.}

\item{scale}{Boolean: indicate whether the coefficients should be 
transformed to standard scores (default: scale = TRUE).}

\item{labels}{Boolean: indicate if x axis labels should be included
(default: labels = TRUE).}

\item{markers}{Boolean: indicate if data points markers should be drawn
(default: markers = TRUE).}
}
\value{
line plot
}
\description{
\code{plot_deconvolute} allows to compare methods across cell
types, where the different methods show a high level of agreement or
potentially generate diverging proportion estimates.
}
\details{
Plots the estimated cell types generated by different deconvolution
methods/signature matrices across samples. Scaling is used to directly compare 
deconvolution outputs across methods.
}
\examples{
# load demo PBMCS data
load_ABIS()

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix_ABIS_S0)

# plot deconvolute
plot_deconvolute(deconvoluted = decon)

}
\author{
Vincent Kuettel, Sabina Pfister
}
