% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlate.R
\name{plot_correlate}
\alias{plot_correlate}
\title{Plot of correlations between deconvolution methods}
\usage{
plot_correlate(correlated, method = "heatmap", legend = TRUE)
}
\arguments{
\item{correlated}{output object from \code{correlate}}

\item{method}{plot type ("heatmap" or "boxplot")}

\item{legend}{boolean to display color legend}
}
\value{
Returns a heatmap or violin plot showing the correlation 
distribution of by different methods/signature matrices for each 
cell type
}
\description{
\code{plot_correlate} is used to visualize the results 
obtained by \code{correlation_analysis}.
}
\details{
\code{plot_correlate} plots the correlation of cell type 
proportions across methods in form of a heatmap or a violin plot. 
If methods agree, cell type proportions of the same cell type should 
by strongly correlated. For cell types with weak correlation across 
methods, corresploding estimated cell type proportions should be 
interpreted with caution.
}
\examples{
# load demo PBMCS data
load_ABIS()

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix_ABIS_S0)

# correlate
correl <- correlate(deconvoluted = decon)

# plot correlate
plot_correlate(correlated = correl, 
method="heatmap")

}
\author{
Vincent Kuettel, Sabina Pfister
}
